package cn.com.wawa.manager.biz.vo;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.service.api.dto.WawaCategoryDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

import java.util.List;

@Data
@ApiModel(value = "娃娃类目")
@NoArgsConstructor
public class WawaCategoryVO {

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("类目名称")
    private String categoryName;

    @ApiModelProperty("娃娃数量")
    private Integer wawaNum;

    @ApiModelProperty("排序")
    private Integer rank;

    @ApiModelProperty("状态 1.上线中 0.下线中")
    private Integer state;

    @ApiModelProperty("上线时间")
    private String onlineTime;

    @ApiModelProperty("下线时间")
    private String offlineTime;

    @ApiModelProperty("创建时间")
    private String gmtCreate;

    @ApiModelProperty("删除 1.删除 0.未删除")
    private Integer deleted;

    @ApiModelProperty("类目下的娃娃列表")
    private List<WawaVO> wawaVOList;

    public WawaCategoryVO(WawaCategoryDto dto) {
        BeanUtils.copyProperties(dto, this);
        onlineTime = DateUtils.getSecondStr(dto.getOnlineTime());
        offlineTime = DateUtils.getSecondStr(dto.getOfflineTime());
        gmtCreate = DateUtils.getSecondStr(dto.getGmtCreate());
    }
}
