package cn.com.wawa.manager.biz.vo;

import cn.com.wawa.service.api.dto.GoodsType;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created by gyf . 2017/11/2 .
 */
@ApiModel("娃娃列表页面对象")
@Data
public class WawaVO {

    @ApiModelProperty("娃娃id")
    private Long       id;

    @ApiModelProperty("娃娃名称 ")
    private String     wawaName;

    @ApiModelProperty("娃娃价格")
    private Long       price;

    @ApiModelProperty("成本")
    private Long       primeCost;

    @ApiModelProperty("图片")
    private String     indexImage;

    @ApiModelProperty("在售的娃娃机ids")
    private List<Long> sellerCatcherIds;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date       gmtCreate;

    @ApiModelProperty("抓娃娃电压配置，多段电压用','分隔，必须配置完整才会生效")
    private String     voltage;

    @ApiModelProperty("类型")
    private GoodsType goodsType;

    @ApiModelProperty("详情图片")
    private List<String> detailPics;

    @ApiModelProperty("发货编号")
    private String     deliveryNum;

    @ApiModelProperty("权重")
    private Long payload;

    @ApiModelProperty("首页是否展示 0不展示 1展示")
    private Integer homeShowStatus;

    @ApiModelProperty("娃娃在娃娃机中的投放数量")
    private Integer luanchQuantity;

    @ApiModelProperty("概率")
    private BigDecimal rate;

    @ApiModelProperty("娃娃角标图片")
    private String cornerPic;

    @ApiModelProperty("返奖率")
    private Long returnAwardRate;

    @ApiModelProperty("抓取类型 1-首次必中 2-概率抓取")
    private Integer catchType;

    @ApiModelProperty("是否代抓")
    private Boolean replaceCatch;

    @ApiModelProperty("上下架状态 1.上架 0.下架")
    private Integer state;

    @ApiModelProperty("采购状态 true.采购 false.不采购")
    private Boolean purchaseState;

    @ApiModelProperty("特价")
    private Long specialPrice;
    @ApiModelProperty("特价上线时间")
    private Date priceOnTime;
    @ApiModelProperty("特价下线时间")
    private Date priceOffTime;

    @ApiModelProperty("兑换券数量 0.不支持兑换")
    private Integer ticketNum;

    @ApiModelProperty("是否支持兑换 1.是 0.否")
    private Integer supportExchange;

    @ApiModelProperty("娃娃类目")
    private String categoryName;

    @ApiModelProperty("是否支持兑换抓抓币 1.是 0.否")
    private Integer exchangeCoin;

    @ApiModelProperty("是否支持霸机闪充 1.是 0.否")
    private Integer supportOcc;
}
