package cn.com.wawa.manager.biz.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * Created by gyf .
 * 2017/10/31 .
 */
@Data
@ApiModel("抓中娃娃列表")
public class WinOrderVO {

    @ApiModelProperty("抓中娃娃订单id")
    private Long id;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("发货订单id")
    private Long deliveryOrderId;

    @ApiModelProperty("抓了一次订单id")
    private Long orderId;

    @ApiModelProperty("抓中数量")
    private Integer quantity;

    @ApiModelProperty("娃娃机名称")
    private String catcherName;

    @ApiModelProperty("娃娃id")
    private Long wawaId;

    @ApiModelProperty("抓中订单的状态, 0寄存中 1待发货 2已发货 3已收回 4已领取")
    private Integer winOrderStatus;

    @ApiModelProperty("收回原因")
    private String receiveReason;

    @ApiModelProperty("收回原因管理员后台看到的")
    private String receiceReason4admin;

    @ApiModelProperty("收回操作时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date receiceTime;

    @ApiModelProperty("收回操作人")
    private String receicePerson;

    @ApiModelProperty("视频url")
    private String videoUrl;

    @ApiModelProperty("抓中时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date gmtCreate;

    @ApiModelProperty("娃娃名称")
    private String wawaName;

    @ApiModelProperty("用户名称")
    private String nickName;

    @ApiModelProperty("娃娃类型")
    private Integer wawaType;

    @ApiModelProperty("扩展字段json串 key：virtualGoodsRemark表示领取备注 key:virtualGoodsRecord表示后台记录")
    private String ext;

    @ApiModelProperty("娃娃机id")
    private Long catcherId;

    @ApiModelProperty("审核状态 1-已审核,0-未审核 2-审核超过2小时")
    private Integer audit;

}
