package cn.com.wawa.manager.biz.vo.title;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.service.api.dto.title.TitleLevelDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

/**
 * 称号等级
 *
 * @author huangjunping
 */
@Data
@ApiModel(value = "称号等级")
@NoArgsConstructor
public class TitleLevelVO {

    @ApiModelProperty("主键")
    private int id;

    @ApiModelProperty("等级名称")
    private String name;

    @ApiModelProperty("光影渲染效果 0.无 1.炫酷 2.普通")
    private Integer lightingRender;

    @ApiModelProperty("头像框")
    private String avatarBox;

    @ApiModelProperty("进房间是否有炫酷播报 0.无 1.有")
    private int roomBroadcast;

    @ApiModelProperty("聊天框中是否有炫酷播报 0.无 1.有")
    private int chattingBroadcast;

    @ApiModelProperty("创建时间")
    private String gmtCreate;

    @ApiModelProperty("修改时间")
    private String gmtModified;

    public TitleLevelVO(TitleLevelDto dto) {
        BeanUtils.copyProperties(dto, this);
        this.gmtCreate = DateUtils.getSecondStr(dto.getGmtCreate());
        this.gmtModified = DateUtils.getSecondStr(dto.getGmtModified());
    }
}
