package cn.com.wawa.manager.biz.vo.title;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.wawa.service.api.dto.title.UserTitleDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

/**
 * 用户称号
 */
@Data
@ApiModel(value = "用户称号")
@NoArgsConstructor
public class UserTitleVO {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("称号ID")
    private Integer titleId;

    @ApiModelProperty("启用状态 0.停用 1.启用")
    private Integer usedStatus;

    @ApiModelProperty("称号状态 0.失效 1.生效中")
    private Integer status;

    @ApiModelProperty("获取到的称号过期时间")
    private String expireTime;

    @ApiModelProperty("创建时间")
    private String gmtCreate;

    @ApiModelProperty("修改时间")
    private String gmtModified;

    public UserTitleVO(UserTitleDto dto) {
        BeanUtils.copyProperties(dto, this);
        this.gmtCreate = DateUtils.getSecondStr(dto.getGmtCreate());
        this.gmtModified = DateUtils.getSecondStr(dto.getGmtModified());
    }
}
