/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.bean.ConnectionConfig;
import cn.com.wawa.proxy.api.event.impl.ClientPushEvent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public abstract class ConnectionClient {
    private ConnectionConfig connectionConfig;

    public void init(String ip, String post) {
        this.connectionConfig = new ConnectionConfig.Builder(Integer.valueOf(post)).setIp(ip).build();
        this.connect();
    }

    public IoSession connect() {
        NioSocketConnector connector = new NioSocketConnector();
        connector.setHandler((IoHandler)new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                this.messageReceived(session, message);
            }
        });
        connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        connector.getFilterChain().addLast("objectFilter", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        ConnectFuture future = null;
        IoSession ioSession = null;
        try {
            future = connector.connect((SocketAddress)new InetSocketAddress(this.connectionConfig.getIp(), this.connectionConfig.getPort()));
            future.awaitUninterruptibly();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (future != null) {
            ioSession = future.getSession();
            ClientPushEvent clientPushEvent = new ClientPushEvent();
            clientPushEvent.setUseId(1L);
            ioSession.write(clientPushEvent);
        }
        return ioSession;
    }

    public abstract void messageReceived(IoSession var1, Object var2);
}

