package cn.com.wawa.proxy.api.event.impl;

import cn.com.wawa.proxy.api.event.PushEvent;

import java.io.Serializable;

/**
 * Created by danke on 2017/11/14.
 * 推送给客户端的事件,包含客户端状态变更所需要的值
 * 推送事件参数由上游准备,下游只负责推送
 */
public class ClientPushEvent<T> implements Serializable, PushEvent {

    /**
     * 用于标示用户,用于作为会话的key
     */
    private Long useId;
    /**
     * 业务类型,约定俗成,更具业务类型定义业务值
     */
    private Integer bizType;
    /**
     * 业务值
     */
    private String bizVal;
    /**
     * 群组id
     */
    private Long groupId;

    /**
     * 上下文,具体碰过之后定义,总感觉上面信息不够
     */
    private T context;

    public Long getUseId() {
        return useId;
    }

    public void setUseId(Long useId) {
        this.useId = useId;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getBizVal() {
        return bizVal;
    }

    public void setBizVal(String bizVal) {
        this.bizVal = bizVal;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public T getContext() {
        return context;
    }

    public void setContext(T context) {
        this.context = context;
    }
}
