package cn.com.wawa.proxy.api.enums;

/**
 * Created by danke on 2017/11/30.
 * 会话类型:用户端会话,机器会话,业务端会话
 */
public enum  SessionTypeEnums {

    USER(1,"和用户建立的会话"),
    MACHINE(2,"和娃娃机建立的会话"),
    SERVICE(3,"和业务服务器建立的会话");

    private int code;
    private String msg;

    public static SessionTypeEnums getByCode(int code) {
        for (SessionTypeEnums enumVal : SessionTypeEnums.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    public static SessionTypeEnums getByRequestCode(int requestCode){
        RequestCodeEnums requestCodeEnums = RequestCodeEnums.getByCode(requestCode);
        if (null == requestCodeEnums)
            return null;
        switch (requestCodeEnums){
            case CREATE_USER:
                return USER;
            case CREATE_MACHINE:
                return MACHINE;
            case CREATE_SERVICE:
                return SERVICE;
            case TO_USER:
                return USER;
            case TO_MACHINE:
                return MACHINE;
            case TO_SERVICE:
                return SERVICE;
            default:
                return null;
        }
    }

    SessionTypeEnums(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
