package cn.com.wawa.service.api.enums;

/**
 *  用户性别枚举
 */
public enum UserSexEnum {

    UN_KNOWN(0, "未知"),
    MAIL(1, "男性"),
    FEMAIL(2, "女性");

    private int    value;
    private String desc;

    UserSexEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static UserSexEnum get(int value) {
        for (UserSexEnum item : UserSexEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
