package cn.com.wawa.service.api.enums;

/**
 *  用户位运算字段枚举
 */
public enum UserSwitchesEnum {

    NEW_BONUS(0, "是否发放了新人红包"),
    FIRST_CHARGE(1, "是否发放了首冲奖励"),
    INVITED_BONUS(2,"被邀请奖励");

    private int    value;
    private String desc;

    UserSwitchesEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static UserSwitchesEnum get(int value) {
        for (UserSwitchesEnum item : UserSwitchesEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
