package cn.com.wawa.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.DeliveryDto;
import cn.com.wawa.service.api.dto.DeliveryOrderDto;
import cn.com.wawa.service.api.enums.DeliveryStatusEnum;

/**
 * Created by gyf .
 * 2017/10/31 .
 */
@AdvancedFeignClient
public interface RemoteDeliveryOrderService {

    /**
     * 查询分页列表
     * @param userId
     * @param deliveryStatus
     * @param pagerRequest
     * @return
     */
    PagerResponse<DeliveryOrderDto> page(Long userId, DeliveryStatusEnum deliveryStatus, PagerRequest pagerRequest);

    /**
     * 发货
     * @param deliveryDto
     * @return
     */
    Boolean send(DeliveryDto deliveryDto);

}
