package cn.com.wawa.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.WawaDto;
import cn.com.wawa.service.api.dto.WawaEditDto;
import cn.com.wawa.service.api.dto.WawaSaveDto;
import cn.com.wawa.service.api.dto.WawaSelectedDto;

import java.util.List;

/**
 * Created by gyf .
 * 2017/10/24 .
 */
@AdvancedFeignClient
public interface RemoteWawaService {

    /**
     * 娃娃待选列表
     * @return
     */
    List<WawaSelectedDto> findSelectedList();

    /**
     * 分页列表
     * @param pagerRequest
     * @return
     */
    PagerResponse<WawaDto> page(PagerRequest pagerRequest);

    /**
     * 删除娃娃机
     * @param wawaId
     * @return
     */
    Boolean delete(Long wawaId);

    /**
     * 保存,带id就是更新,不带id就是插入
     * @param wawa
     * @return
     */
    Boolean save(WawaSaveDto wawa);

    /**
     * 查询单个用于编辑
     * @param wawaId
     * @return
     */
    WawaEditDto find(Long wawaId);


}
