package cn.com.wawa.service.api.tools;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by gyf .
 * 2017/10/30 .
 */
public class WawaStringUtils {

    private WawaStringUtils() {
    }

    public static List<String> str2List(String str) {
        if (StringUtils.isBlank(str)) {
            return Collections.emptyList();
        }
        Splitter splitter = Splitter.on(",");
        splitter.trimResults();
        return Lists.newArrayList(splitter.split(str));
    }

    public static List<Long> strList2LongList(List<String> strList) {
        if (CollectionUtils.isEmpty(strList)) {
            return Collections.emptyList();
        }
        List<Long> longList = new ArrayList<>(strList.size());
        for (String it : strList) {
            longList.add(Long.valueOf(it));
        }
        return longList;
    }

    public static List<Long> str2longList(String str) {
        if (StringUtils.isBlank(str)) {
            return Collections.emptyList();
        }
        return strList2LongList(str2List(str));

    }
}
