package cn.com.wawa.service.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

@ApiModel(value = "版本信息")
public class VersionDto implements Serializable {
    private static final long serialVersionUID = -5535822086764301408L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "版本号")
    private String versionName;

    @ApiModelProperty(value = "弹窗图片地址")
    private String picUrl;

    @ApiModelProperty(value = "上下线状态  0-下线  1-上线")
    private Integer status;

    @ApiModelProperty(value = "平台 0:安卓 1：ios")
    private Integer clientType;

    @ApiModelProperty(value = "下载地址")
    private String url;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date gmtCreate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getVersionName() {
        return versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getPicUrl() {
        return picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getClientType() {
        return clientType;
    }

    public void setClientType(Integer clientType) {
        this.clientType = clientType;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
}
