package cn.com.wawa.service.api.enums;

/**
 * 用户账户变动明细类型
 */
public enum AccountChangeTypeEnum {

    CHARGE(1, "充值"),
    FIRST_CHARGE(2, "首冲奖励"),
    CATCH_WAWA(3, "抽娃娃消费"),
    POSTAGE(4, "邮费"),
    NEW_USER_GIFT(5,"新人奖励"),
    NEW_USER_INVITED(6,"新人被邀请奖励"),
    INVITE_BONUS(7,"邀请奖励"),
    ACTIVITY_RECEIVE(8, "活动赠送"),
    CREDITS_CONSUME(9,"积分商城消费"),
    ROLL_BACK(10, "回滚操作");

    private int    value;
    private String desc;

    AccountChangeTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static AccountChangeTypeEnum get(int value) {
        for (AccountChangeTypeEnum item : AccountChangeTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
