package cn.com.wawa.service.api.enums;

/**
 * Created by danke on 2017/12/11.
 * 用户类型枚举
 */
public enum UserTypeEnum {

    ORDINARY_USER("ORDINARY_USER","普通用户"),
    TEST_USER("TEST_USER","测试用户"),
    BLACK_USER("BLACK_USER","黑名单用户");

    private String code;

    private String msg;

    UserTypeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static UserTypeEnum get(String code) {
        for (UserTypeEnum item : UserTypeEnum.values()) {
            if (item.getCode().equals(code)) {
                return item;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
