package cn.com.wawa.service.api.enums;

/**
 * 用户账户变动明细类型
 * code标示增减类型0-增加 1-减少
 */
public enum AccountChangeTypeEnum {

    CHARGE(1, "充值",0),
    FIRST_CHARGE(2, "首冲奖励",0),
    CATCH_WAWA(3, "抽娃娃消费",1),
    POSTAGE(4, "邮费",1),
    NEW_USER_GIFT(5,"新人奖励",0),
    NEW_USER_INVITED(6,"新人被邀请奖励",0),
    INVITE_BONUS(7,"邀请奖励",0),
    ACTIVITY_RECEIVE(8, "活动赠送",0),
    CREDITS_CONSUME(9,"积分商城消费",1),
    ROLL_BACK(10, "回滚操作",1),
    RED_PACKAGE_RECEIVE(11, "红包赠送",0),
    STRONG_GRAB_NO_CATCHED(12, "强抓不中送币",0);


    private int    value;
    private String desc;
    private int code;

    AccountChangeTypeEnum(int value, String desc,int code) {
        this.value = value;
        this.desc = desc;
        this.code = code;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public int code (){
        return code;
    }

    public static AccountChangeTypeEnum get(int value) {
        for (AccountChangeTypeEnum item : AccountChangeTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
