package cn.com.wawa.service.api.enums;

/**
 * 娃娃机的机器健康状态
 */
public enum WawaCatcherHealthStatusEnum {

    HEALTH(0, "健康"),
    NOT_HEALTH(1, "不健康");

    private int    value;
    private String desc;

    WawaCatcherHealthStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static WawaCatcherHealthStatusEnum get(int value) {
        for (WawaCatcherHealthStatusEnum item : WawaCatcherHealthStatusEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
