package cn.com.wawa.service.api.dto;

import cn.com.wawa.service.api.enums.WawaCatcherHealthStatusEnum;
import cn.com.wawa.service.api.enums.WawaCatcherStatusEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by gyf . 2017/10/27 .
 */
public class WawaCatcherDto implements Serializable {

    private static final long           serialVersionUID = 7674424771006935130L;

    /**
     * 娃娃机id
     */
    private Long                        id;

    /**
     * 娃娃机名称
     */
    private String                      catcherName;

    /**
     * 娃娃机上配置的价格/ 需要使用娃娃覆盖
     */
    private Long                        price;

    /**
     * 娃娃机排序值
     */
    private Long                        payload;

    /**
     * 娃娃id
     */
    private Long                        wawaId;

    /**
     * 娃娃图
     */
    private String                      indexImage;

    /**
     * 娃娃名称
     */
    private String                      wawaName;

    /**
     * 状态 0补货维护 1上架
     */
    private WawaCatcherStatusEnum       catcherStatus;

    /**
     * 健康状态 0健康 1不健康
     */
    private WawaCatcherHealthStatusEnum healthStatus;

    /**
     * 最新一次上架时间
     */
    private Date                        lastOnshelfTime;

    /**
     * 娃娃总数
     */
    private Integer                     totality;

    /**
     * 娃娃剩余数量
     */
    private Integer                     stock;

    /** 娃娃机版本号 */
    private String                      catcherVersion;

    /**最后补齐娃娃数量时间*/
    private Date                        lastPolishTime;

    private String remark;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCatcherName() {
        return catcherName;
    }

    public void setCatcherName(String catcherName) {
        this.catcherName = catcherName;
    }

    public Long getPrice() {
        return price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public Long getPayload() {
        return payload;
    }

    public void setPayload(Long payload) {
        this.payload = payload;
    }

    public Long getWawaId() {
        return wawaId;
    }

    public void setWawaId(Long wawaId) {
        this.wawaId = wawaId;
    }

    public String getIndexImage() {
        return indexImage;
    }

    public void setIndexImage(String indexImage) {
        this.indexImage = indexImage;
    }

    public String getWawaName() {
        return wawaName;
    }

    public void setWawaName(String wawaName) {
        this.wawaName = wawaName;
    }

    public WawaCatcherStatusEnum getCatcherStatus() {
        return catcherStatus;
    }

    public void setCatcherStatus(WawaCatcherStatusEnum catcherStatus) {
        this.catcherStatus = catcherStatus;
    }

    public WawaCatcherHealthStatusEnum getHealthStatus() {
        return healthStatus;
    }

    public void setHealthStatus(WawaCatcherHealthStatusEnum healthStatus) {
        this.healthStatus = healthStatus;
    }

    public Date getLastOnshelfTime() {
        return lastOnshelfTime;
    }

    public void setLastOnshelfTime(Date lastOnshelfTime) {
        this.lastOnshelfTime = lastOnshelfTime;
    }

    public Integer getTotality() {
        return totality;
    }

    public void setTotality(Integer totality) {
        this.totality = totality;
    }

    public Integer getStock() {
        return stock;
    }

    public void setStock(Integer stock) {
        this.stock = stock;
    }

    /**
     * catcherVersion.
     *
     * @return the catcherVersion
     */
    public String getCatcherVersion() {
        return catcherVersion;
    }

    /**
     * catcherVersion.
     *
     * @param catcherVersion the catcherVersion to set
     */
    public void setCatcherVersion(String catcherVersion) {
        this.catcherVersion = catcherVersion;
    }


    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getLastPolishTime() {
        return lastPolishTime;
    }

    public void setLastPolishTime(Date lastPolishTime) {
        this.lastPolishTime = lastPolishTime;
    }
}
