package cn.com.wawa.service.api.dto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 娃娃
 */
@Data
@ApiModel(value = "娃娃信息")
public class WawaDto implements Serializable {

    private static final long serialVersionUID = -181429783319351596L;

    private Long              id;

    private String            wawaName;

    private Long              price;

    private Long              primeCost;

    private String            indexImage;

    private Integer           deleted;

    private List<Long>        sellerCatcherIds;

    private Date              gmtCreate;

    private Date              gmtModified;

    /** 抓娃娃电压配置，多段电压用","分隔，必须配置完整才会生效 */
    private String            voltage;

    private GoodsType             goodsType;

    private List<String>        detailPics;
    private String            deliveryNum;

    private Long payload;

    private Integer homeShowStatus;
    /**娃娃在娃娃机中的投放数量*/
    private Integer luanchQuantity;

    @ApiModelProperty(value = "概率")
    private BigDecimal rate;
}
