package cn.com.wawa.service.api.dto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by gyf . 2017/10/27 .
 */
@Data
@ApiModel(value = "娃娃编辑信息")
public class WawaEditDto implements Serializable {

    private static final long serialVersionUID = -3924951029246305235L;

    private Long              id;

    private String            wawaName;

    private Long              price;

    private Long              primeCost;

    /** 抓娃娃电压配置，多段电压用","分隔，必须配置完整才会生效 */
    private String            voltage;

    /**
     * 概率展示
     */
    private String            showPercent;

    private String            indexImage;

    private String            deliveryNum;

    private GoodsType            goodsType;

    private List<String>      detailPics;

    private Long payload;

    private Integer homeShowStatus;

    /**娃娃在娃娃机中的投放数量*/
    private Integer luanchQuantity;

    @ApiModelProperty(value = "首次必中  1-是   2-否(概率抓取)")
    private Integer catchType;

    @ApiModelProperty(value = "详情中的娃娃名称")
    private String detailWawaName;
    @ApiModelProperty(value = "详情中的详情描述")
    private String detailDescr;
    @ApiModelProperty(value = "概率")
    private BigDecimal rate;
}
