package cn.com.wawa.service.api.dto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Created by gyf . 2017/10/27 .
 */
@Data
@ApiModel(value = "娃娃保存信息")
public class WawaSaveDto implements Serializable {

    private static final long serialVersionUID = 7041703886449031029L;

    private Long              id;

    private String            wawaName;

    private Long              price;

    private Long              primeCost;

    private String            indexImage;
    /** 抓娃娃电压配置，多段电压用","分隔，必须配置完整才会生效 */
    private String            voltage;

    private Integer             wawaType;

    private List<String>        wawaDetailPics;
    private String            deliveryNum;

    private Long payload;

    private Integer homeShowStatus;
    /**娃娃在娃娃机中的投放数量*/
    private Integer luanchQuantity;

    @ApiModelProperty(value = "首次必中  1-是   2-否(概率抓取)")
    private Integer catchType;
    @ApiModelProperty(value = "详情中的娃娃名称")
    private String detailWawaName;
    @ApiModelProperty(value = "详情中的详情描述")
    private String detailDescr;
}
