package cn.com.wawa.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.BannerDto;
import cn.com.wawa.service.api.dto.StartImageDto;

@AdvancedFeignClient
public interface RemoteStartImageService {
    StartImageDto find(Long id);

    /**
     * insert or update
     * @param startImageDto
     * @return
     */
    Boolean save(StartImageDto startImageDto);

    PagerResponse<StartImageDto> page(PagerRequest pageRequest, Integer status);

    Boolean delete(Long id);

    /**
     * 设置权重
     * @param id
     * @param payload
     * @return
     */
    Boolean setPayload(Long id, Long payload);

    Boolean setStatus(Long id, Integer status);

    Integer countByStatus(Integer status);

}
