/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.service.api.bean;

import com.google.common.base.Preconditions;
import java.io.Serializable;

public class PagerRequest
implements Serializable {
    private static final long serialVersionUID = 2294315351929896870L;
    private Integer pageIndex;
    private Integer pageSize;

    public PagerRequest() {
    }

    public PagerRequest(Integer pageIndex, Integer pageSize) {
        Preconditions.checkArgument((null != pageIndex ? 1 : 0) != 0, (Object)"pageIndex\u65e0\u6548");
        Preconditions.checkArgument((null != pageSize ? 1 : 0) != 0, (Object)"pageSize\u65e0\u6548");
        if (pageIndex <= 0) {
            pageIndex = 1;
        }
        if (pageIndex <= 0) {
            pageSize = 20;
        }
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        Preconditions.checkArgument((null != pageIndex && pageIndex > 0 ? 1 : 0) != 0, (Object)"pageIndex\u65e0\u6548");
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        Preconditions.checkArgument((null != pageSize && pageSize > 0 ? 1 : 0) != 0, (Object)"pageSize\u65e0\u6548");
        this.pageSize = pageSize;
    }

    public Integer getOffset() {
        if (null == this.pageIndex || null == this.pageSize) {
            return null;
        }
        return (this.pageIndex - 1) * this.pageSize;
    }
}

