package cn.com.wawa.service.api.enums;

/**
 * 申诉结果状态枚举
 */
public enum AppealHandleStatusEnum {

    TREATED(1, "已处理"),
    UNTREATED(0, "未处理");

    private int value;
    private String desc;

    AppealHandleStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static AppealHandleStatusEnum get(int value) {
        for (AppealHandleStatusEnum item : AppealHandleStatusEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
    public static boolean isSameHandleStatus(Integer value, AppealHandleStatusEnum appealHandleStatus){
        return value == null ? false : isSameHandleStatus(value.intValue(), appealHandleStatus);
    }
    public static boolean isSameHandleStatus(int value, AppealHandleStatusEnum appealHandleStatus){
        return  appealHandleStatus == null ? false : value == appealHandleStatus.value;
    }
}
