package cn.com.wawa.service.api.enums;

public enum BannerTypeEnum {
    NORMAL(1, "普通"),
    CAPSULE(2, "胶囊位");

    private int    value;
    private String desc;

    BannerTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static BannerTypeEnum get(int value) {
        for (BannerTypeEnum item : BannerTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }

}
