package cn.com.wawa.service.api.enums;

/**
 * 充值费率配置
 */
public enum ChargeBonusConfigTypeEnum {

    NORMAL(1, "普通"),
    FIRST_CHARGE(2, "首冲"),
    SELETED_FIRST_CHARGE(3,"部分用户投放的首冲"),
    CHARGE_BACK_RED(4,"冲反红包对应的特殊档位"),

    GUARANTEE(5,"保底(包赔)红包对应的特殊档位"),
    CHARGE_BACK_RED_NEW(6,"冲反红包对应的特殊档位，不展示在列表里"),
    TUHAO(7,"土豪档位"),
    WEEKLYCARD(8,"周卡");

    private int    value;
    private String desc;

    ChargeBonusConfigTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static ChargeBonusConfigTypeEnum get(int value) {
        for (ChargeBonusConfigTypeEnum item : ChargeBonusConfigTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
