package cn.com.wawa.service.api.enums;

public enum  VersionStatusEnum {
    down(0, "下线"),
    on(1, "上线"),
    delete(2, "删除");

    private int    value;
    private String desc;

    VersionStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static VersionStatusEnum get(int value) {
        for (VersionStatusEnum item : VersionStatusEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
