package cn.com.wawa.service.api.enums;

/**
 * 娃娃机的机器状态
 */
public enum WawaCatcherStatusEnum {

    OFFSHELF(0, "下架"),
    ONSHELF(1, "上架"),
    ONTEST(2,"测试中");

    private int    value;
    private String desc;

    WawaCatcherStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static WawaCatcherStatusEnum get(int value) {
        for (WawaCatcherStatusEnum item : WawaCatcherStatusEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
