package cn.com.wawa.service.api.dto.title;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 称号等级
 *
 * @author huangjunping
 */
@Data
public class TitleLevelDto implements Serializable {

    private static final long serialVersionUID = 5712965174549835360L;

    /**
     * 主键
     */
    private int id;

    /**
     * 等级名称
     */
    private String name;

    /**
     * 光影渲染效果 0.无 1.炫酷 2.普通
     */
    private Integer lightingRender;

    /**
     * 头像框
     */
    private String avatarBox;

    /**
     * 进房间是否有炫酷播报 0.无 1.有
     */
    private int roomBroadcast;

    /**
     * 聊天框中是否有炫酷播报 0.无 1.有
     */
    private int chattingBroadcast;

    /**
     * 等级排序 倒序，eg. SS.4  S.3  A.2  B.1
     */
    private Integer level;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

}
