package cn.com.wawa.service.api.enums;

public enum ChargeBonusAfterChargeBehavierEnum {

    NOTHING(0, "不做操作"),
    DISABLE_AFTER_CURRENT_DEGREE(1, "充值当前档位后关闭"),
    DISABLE_AFTER_ANY_DEGREE(2, "充值任意档位后关闭"),
    DISABLE_AFTER_CHARGE_15(3,"充值15元后关闭");

    private int    value;
    private String desc;

    ChargeBonusAfterChargeBehavierEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static ChargeBonusAfterChargeBehavierEnum get(int value) {
        for (ChargeBonusAfterChargeBehavierEnum item : ChargeBonusAfterChargeBehavierEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
