package cn.com.wawa.service.api.enums;

/**
 * 充值弹窗类型（存在tb_charge_pop_window表里的）
 */
public enum ChargePopWindowTypeEnum {
    FIRSTCHARGE(1, "首冲弹窗"),
    GUIDEREDPACKAGE(2, "引导红包弹窗"),
    GUIDE_CHARGE_REDPACKAGE(3, "引导充值红包弹窗"),
    DELIVERY_REMIND(4,"发货提醒需求");

    private int    value;
    private String desc;

    ChargePopWindowTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static ChargePopWindowTypeEnum get(int value) {
        for (ChargePopWindowTypeEnum item : ChargePopWindowTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
