package cn.com.wawa.service.api.dto;

import lombok.Data;

import java.util.Date;

@Data
public class PushInfoDto {

    private Long id;

    /**
     * 消息Id
     **/
    private Long msgId;

    /**
     * 推送名称
     **/
    private String pushName;

    /**
     * 推送标题
     **/
    private String pushTitle;

    /**
     * 推送内容
     **/
    private String pushContent;

    /**
     * 跳转url
     **/
    private String url;

    /**
     * 跳转url类型 1-h5 2-原生
     **/
    private int urlType;

    /**
     * 接受平台 0-安卓 1-ios
     **/
    private int client;

    /**
     * 目标用户类型 1-全推  2-部分用户
     **/
    private int targetUserType;

    /**
     * 推送用户文件
     **/
    private String userIdsFile;

    /**
     * 推送时间
     **/
    private Date pushTime;

    /**
     * 推送状态 1-未发送  2-待发送  3-已发送
     **/
    private int pushStatus;

    /**
     * 目标用户量
     **/
    private Long targetUserNum;

    /**
     * 接受用户量
     **/
    private Long receivedUserNum;

    /**
     * 点击用户量
     **/
    private Long clickUserNum;

    /**
     * 创建时间
     **/
    private Date gmtCreate;

    /**
     * 修改时间
     **/
    private Date gmtModified;
}
