package cn.com.wawa.service.api.dto.groupbook;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * Created by danke on 2018/2/27.
 * 拼团实体dto
 */
@ApiModel(value = "拼团活动信息")
public class GroupBookDto{

    @ApiModelProperty("拼团活动id")
    private Long id;

    @ApiModelProperty("拼团标题")
    private String title;

    @ApiModelProperty("拼团人数")
    private Integer groupBookNum;

    @ApiModelProperty("拼团参与门槛金额,现价")
    private Long money;

    @ApiModelProperty("分享标题")
    private String shareTitle;

    @ApiModelProperty("分享图片链接")
    private String shareImageUrl;

    @ApiModelProperty("还剩1小时拼团结束的推送标题")
    private String endPushTitle;

    @ApiModelProperty("还剩1小时拼团结束的推送内容")
    private String endPushContent;

    @ApiModelProperty("乐豆")
    private Integer beans;

    @ApiModelProperty("分享副标题")
    private String shareViceTitle;

    @ApiModelProperty("奖品名称")
    private String awardName;

    @ApiModelProperty("奖品图片")
    private String awardPic;

    @ApiModelProperty("原价")
    private Long originalPrice;

    @ApiModelProperty("奖品banner图片 多张图片地址之前用英文;号相连")
    private String awardBannerPic;

    @ApiModelProperty("奖品详情图 多张图片地址之前用英文;号相连")
    private String awardDetailPic;

    @ApiModelProperty("中奖概率")
    private Long winProb;

    @ApiModelProperty("库存")
    private Integer stock;

    @ApiModelProperty("状态 0-待上线 1-上线  2-下线  -1-删除")
    private Integer groupStatus;

    @ApiModelProperty("状态描述")
    private String statusDscr;

    @ApiModelProperty("上线时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date onLineTime;

    @ApiModelProperty("下线时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date offLineTime;

    @ApiModelProperty("排序")
    private int sort;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date gmtCreate;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getGroupBookNum() {
        return groupBookNum;
    }

    public void setGroupBookNum(Integer groupBookNum) {
        this.groupBookNum = groupBookNum;
    }

    public Long getMoney() {
        return money;
    }

    public void setMoney(Long money) {
        this.money = money;
    }

    public String getShareTitle() {
        return shareTitle;
    }

    public void setShareTitle(String shareTitle) {
        this.shareTitle = shareTitle;
    }

    public String getShareImageUrl() {
        return shareImageUrl;
    }

    public void setShareImageUrl(String shareImageUrl) {
        this.shareImageUrl = shareImageUrl;
    }

    public Integer getBeans() {
        return beans;
    }

    public void setBeans(Integer beans) {
        this.beans = beans;
    }

    public String getShareViceTitle() {
        return shareViceTitle;
    }

    public void setShareViceTitle(String shareViceTitle) {
        this.shareViceTitle = shareViceTitle;
    }

    public String getAwardName() {
        return awardName;
    }

    public void setAwardName(String awardName) {
        this.awardName = awardName;
    }

    public Long getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(Long originalPrice) {
        this.originalPrice = originalPrice;
    }

    public String getAwardBannerPic() {
        return awardBannerPic;
    }

    public void setAwardBannerPic(String awardBannerPic) {
        this.awardBannerPic = awardBannerPic;
    }

    public String getAwardDetailPic() {
        return awardDetailPic;
    }

    public void setAwardDetailPic(String awardDetailPic) {
        this.awardDetailPic = awardDetailPic;
    }

    public Long getWinProb() {
        return winProb;
    }

    public void setWinProb(Long winProb) {
        this.winProb = winProb;
    }

    public Integer getStock() {
        return stock;
    }

    public void setStock(Integer stock) {
        this.stock = stock;
    }

    public Integer getGroupStatus() {
        return groupStatus;
    }

    public void setGroupStatus(Integer groupStatus) {
        this.groupStatus = groupStatus;
    }

    public int getSort() {
        return sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getAwardPic() {
        return awardPic;
    }

    public void setAwardPic(String awardPic) {
        this.awardPic = awardPic;
    }

    public Date getOnLineTime() {
        return onLineTime;
    }

    public void setOnLineTime(Date onLineTime) {
        this.onLineTime = onLineTime;
    }

    public Date getOffLineTime() {
        return offLineTime;
    }

    public void setOffLineTime(Date offLineTime) {
        this.offLineTime = offLineTime;
    }

    public String getEndPushTitle() {
        return endPushTitle;
    }

    public void setEndPushTitle(String endPushTitle) {
        this.endPushTitle = endPushTitle;
    }

    public String getEndPushContent() {
        return endPushContent;
    }

    public void setEndPushContent(String endPushContent) {
        this.endPushContent = endPushContent;
    }

    public String getStatusDscr() {
        return statusDscr;
    }

    public void setStatusDscr(String statusDscr) {
        this.statusDscr = statusDscr;
    }
}
