package cn.com.wawa.service.api.dto.tabconfig;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by danke on 2018/3/20.
 * 我的页面配置表
 */
@ApiModel(value = "我的页面配置")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TabCategoryConfigDto {

    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("通道图标")
    private String icon;
    @ApiModelProperty("跳转链接")
    private String jpUrl;
    @ApiModelProperty("通道名称")
    private String tabName;
    @ApiModelProperty("通道状态")
    private Integer tabStatus;
    @ApiModelProperty("通道类别")
    private Integer tabCategory;
    @ApiModelProperty("通道排序")
    private Integer tabSort;
    @ApiModelProperty("类别排序")
    private Integer categorySort;
    @ApiModelProperty("最小投放版本")
    private String minVersion;
    @ApiModelProperty("最小投放版本")
    private String maxVersion;
    @ApiModelProperty("是否删除 false")
    private boolean deleted;
    @ApiModelProperty("页面配置类型 0 -我的页面")
    private Integer tabType;
}
