package cn.com.wawa.service.api.dto.title;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class TitleConfigDto implements Serializable{

    private static final long serialVersionUID = 5079528384947774708L;

    /**
     * 主键
     */
    private int id;

    /**
     * 称号名称
     */
    private String name;

    /**
     * 称号图片
     */
    private String image;

    /**
     * 称号类型 1.成就 2.活动
     */
    private int type = 1;

    /**
     * 二级类别 11.累充 12.累计娃娃 13.连续抓中 14.一爪抓多只 21.充值排行榜 22.抓中排行榜
     */
    private int secondType = 11;

    /**
     * 上限条件 充值单位为元，抓中娃娃单位为只；type = 2，该字段有用
     */
    private int upperLimit;

    /**
     * 下限条件 充值单位为元，抓中娃娃单位为只
     */
    private int lowerLimit;

    /**
     * 获取条件文案
     */
    private String description;

    /**
     * 称号等级ID
     */
    private int levelId;

    /**
     * 有效天数 -1.永久
     */
    private int validDays = -1;

    /**
     * 是否展示称号进度 1.是 0.否
     */
    private int progressShow;

    /**
     * 获得的称号是否浮层展示 1.是 0.否
     */
    private int supernatantShow;

    /**
     * 称号备注
     */
    private String remark;

    /**
     * 称号状态 0.未上线 1.上线中 2. 已下线 3. 归档
     */
    private int status;

    /**
     * 上线时间
     */
    private Date onlineTime;

    /**
     * 下线时间
     */
    private Date offlineTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

}
