package cn.com.wawa.service.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by danke on 2017/12/11.
 */
public enum BlackListEnum {

    USER_ID("USER_ID","用户id");

    private static Map<String,BlackListEnum> blackMap = Maps.newHashMap();
    static {
        for(BlackListEnum it:BlackListEnum.values()){
            blackMap.put(it.getBkType(),it);
        }
    }

    private String bkType;
    private String describe;

    BlackListEnum(String bkType,String describe){
        this.bkType = bkType;
        this.describe = describe;
    }


    public static BlackListEnum getEnumByType(String type){
        return blackMap.get(type);
    }

    public String getBkType() {
        return bkType;
    }

    public String getDescribe() {
        return describe;
    }

}
