package cn.com.wawa.service.api.enums;

public enum WeixinChargeTradeTypeEnum {

    APP("APP","app充值"),
    OFFICIAL_ACCOUNT("JSAPI","公众号充值"),
    H5("MWEB","H5充值");

    private String value;

    private String desc;

    WeixinChargeTradeTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static WeixinChargeTradeTypeEnum get(String value) {
        for (WeixinChargeTradeTypeEnum item : WeixinChargeTradeTypeEnum.values()) {
            if (item.value().equals( value)) {
                return item;
            }
        }
        return null;
    }
}
