package cn.com.wawa.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.RiskDetailDto;
import cn.com.wawa.service.api.dto.RiskDto;

import java.util.Date;

/**
 * Created by houwen on 2018/4/26.
 */
@AdvancedFeignClient
public interface RemoteRiskService {

    /**
     * 查询用户返奖率
     *
     * @param userId
     * @param pageRequest
     * @return
     */
    PagerResponse<RiskDto> findUserCountPage(Long userId, PagerRequest pageRequest);

    /**
     * 查询机器返奖率
     *
     * @param catcherName
     * @param pageRequest
     * @return
     */
    PagerResponse<RiskDto> findMachineCountPage(String catcherName, PagerRequest pageRequest);

    /**
     * 查询用户返奖率明细
     *
     * @param userId
     * @param start
     * @param end
     * @param pageRequest
     * @return
     */
    PagerResponse<RiskDetailDto> findUserCountDetailPage(Long userId, Date start, Date end, PagerRequest pageRequest);

    /**
     * 查询机器返奖率明细
     *
     * @param catcherName
     * @param start
     * @param end
     * @param pageRequest
     * @return
     */
    PagerResponse<RiskDetailDto> findMachineCountDetailPage(String catcherName, Date start, Date end, PagerRequest pageRequest);


}
