package cn.com.wawa.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.VirtualGoodsReceiveDto;
import cn.com.wawa.service.api.dto.WinOrderDto;
import cn.com.wawa.service.api.dto.WinOrderReceiveDto;

/**
 * Created by gyf .
 * 2017/10/31 .
 */
@AdvancedFeignClient
public interface RemoteWinOrderService {

    /**
     * 查询分页列表
     * @param userId
     * @param winOrderId
     * @param pagerRequest
     * @return
     */
    PagerResponse<WinOrderDto> page(Long userId, Long winOrderId,String catcherName,String wawaName,String beginTime,String endTime, Integer type, PagerRequest pagerRequest);

    /**
     * 收回娃娃
     * @param receiveDto
     */
    Boolean confiscate(WinOrderReceiveDto receiveDto);

    /**
     * 更新个数
     * @param winOrderId
     * @param quantity
     * @return
     */
    Boolean updateQuantity(Long winOrderId, Integer quantity);

    /**
     * 虚拟物品领取
     * @param dto
     * @return
     */
    Boolean receiveVirtualGoods(VirtualGoodsReceiveDto dto);

    /**
     * 查询当前娃娃机,当前订单的上一笔抓中订单
     */
    WinOrderDto getBeforeWinOrder(Long winOrderId ,Long catcherId);
    /**
     * 查询当前娃娃机,当前订单的下一笔抓中订单
     * @param winOrderId
     * @param catcherId
     * @return
     */
    WinOrderDto getAfterWinOrder(Long winOrderId, Long catcherId);
}
