/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.service.api.exception;

import cn.com.wawa.service.api.enums.ErrorCodeEnum;

public class BusinessException
extends RuntimeException {
    private static final long serialVersionUID = 8968235904335164571L;
    private final int httpStatus;
    private final String outerErrorMsg;
    private final int code;

    public BusinessException(int httpStatus, ErrorCodeEnum errorCode) {
        super(errorCode.getDesc());
        this.code = errorCode.getCode();
        this.outerErrorMsg = errorCode.getDesc();
        this.httpStatus = httpStatus;
    }

    public BusinessException(ErrorCodeEnum errorCode) {
        super(errorCode.getDesc());
        this.code = errorCode.getCode();
        this.outerErrorMsg = errorCode.getDesc();
        this.httpStatus = 200;
    }

    public BusinessException(int httpStatus, ErrorCodeEnum errorCode, Throwable cause) {
        super(cause);
        this.code = errorCode.getCode();
        this.outerErrorMsg = errorCode.getDesc();
        this.httpStatus = httpStatus;
    }

    public BusinessException(String message) {
        super(message);
        this.httpStatus = 200;
        this.outerErrorMsg = message;
        this.code = ErrorCodeEnum.E100000.getCode();
    }

    public int getCode() {
        return this.code;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public String getOuterErrorMsg() {
        return this.outerErrorMsg;
    }
}

