package cn.com.wawa.service.api.dto;

import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("显示玩法风控配置")
public class TimeLimitRiskManageDto implements Serializable {

    private static final long serialVersionUID = -7724266856990139849L;
    /**
     * 前100付费局发券数,2位小数
     */
    private String top100TicketNum;
    /**
     * 弱抓概率参数k,4位小数
     */
    private String weakCatchRateK;
    /**
     * 弱抓保护时间
     */
    private Integer weakProtectTime;
    /**
     * 高难度曲线参数a,4位小数
     */
    private String highDifficultyA;
    /**
     * 中难度曲线参数a,4位小数
     */
    private String middleDifficultyA;
    /**
     * 低难度曲线参数a,4位小数
     */
    private String lowDifficultyA;
    /**
     * 难度曲线上限参数c
     */
    private Integer upperLimitC;
    /**
     * 难度曲线下限参数c
     */
    private Integer lowerLimitC;
    /**
     * 游戏付费局数
     */
    private Integer gameNumber;
    /**
     * 平均得券,2位小数
     */
    private String averageTicket;

    public static TimeLimitRiskManageDto getDefault(){
        TimeLimitRiskManageDto resultBase = new TimeLimitRiskManageDto();
        resultBase.setTop100TicketNum("6.5");
        resultBase.setWeakCatchRateK("550.0000");
        resultBase.setWeakProtectTime(60);
        resultBase.setHighDifficultyA("0.4400");
        resultBase.setMiddleDifficultyA("0.5600");
        resultBase.setLowDifficultyA("0.6500");
        resultBase.setUpperLimitC(8);
        resultBase.setLowerLimitC(6);
        resultBase.setGameNumber(3);
        resultBase.setAverageTicket("10.00");
        return resultBase;
    }
}
