package cn.com.wawa.service.api.enums;

/**
 * 充值类型
 */
public enum ChargeOrderTypeEnum {

    WECHAT(1, "微信支付"),
    ALIPAY(2, "支付宝支付"),
    WECHAT_H5(3,"微信h5支付"),
    WECHAT_OFFICIAL_ACCOUNT(4,"微信公众号支付"),
    ALIPAY_H5(5,"支付宝h5支付"),
    QQ(6,"QQ支付");

    private int    value;
    private String desc;

    ChargeOrderTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static ChargeOrderTypeEnum get(int value) {
        for (ChargeOrderTypeEnum item : ChargeOrderTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }
}
