package cn.com.wawa.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.wawa.service.api.bean.JsonResult;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.PushInfoDto;

import java.util.Set;

@AdvancedFeignClient
public interface RemotePushManagerService {


    PagerResponse<PushInfoDto> page(Integer pageIndex, Integer pageSize, Integer pushStatus, String pushName, String pushTimeStart, String pushTimeEnd) ;

    PushInfoDto getPushInfo(Long pushId);

    JsonResult save(PushInfoDto pushMsgInfo) ;

    JsonResult start(Long pushId) ;

    JsonResult close(Long pushId) ;

    JsonResult delete(Long pushId) ;

    JsonResult testPush(Set<String> userIds, Long pushId);
}
