package cn.com.wawa.service.api.bean;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 功能描述:controller返回数据总格式
 */
@ApiModel("推啊游戏返回json数据")
@Data
public class TuiaResult<T> {
    @ApiModelProperty("扣金币结果状态,ok或fail")
    private String status;
    @ApiModelProperty("出错原因")
    private String errorMessage;
    @ApiModelProperty("请求数据体")
    private T data;
    @ApiModelProperty("推啊订单号")
    private String orderId;
    @ApiModelProperty("用户金币最新余额")
    private String credits;

    /**
     * successResult
     *
     * @param data
     * @param <T>
     * @return
     */
    public static <T> TuiaResult<T> successResult(T data) {
        TuiaResult<T> jsonResult = new TuiaResult<>();
        jsonResult.setStatus("ok");
        jsonResult.setData(data);
        return jsonResult;
    }

    public static <T> TuiaResult<T> successResult() {
        TuiaResult<T> jsonResult = new TuiaResult<>();
        jsonResult.setStatus("ok");
        return jsonResult;
    }


    /**
     * failedResult
     *
     * @param message
     * @param <T>
     * @return
     */
    public static <T> TuiaResult<T> failedResult(String message) {
        TuiaResult<T> jsonResult = new TuiaResult<>();
        jsonResult.setStatus("fail");
        jsonResult.setErrorMessage(message);
        jsonResult.setData(null);
        return jsonResult;
    }


}
