package cn.com.wawa.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class AdConfigDto implements Serializable {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 广告名称
     */
    private String adName;

    /**
     * 类目ID
     */
    private Long categoryId;

    /**
     * 图片地址
     */
    private String image;

    /**
     * 跳转链接
     */
    private String url;

    /**
     * 排序
     */
    private Integer payload;

    /**
     * 广告状态（1：上线 2：下线）
     */
    private Integer adStatus;

    /**
     * 上线时间
     */
    private Date openTime;

    /**
     * 下线时间
     */
    private Date closeTime;

    /**
     * 最小版本
     */
    private Integer minVersionCode;

    /**
     * 最大版本
     */
    private Integer maxVersionCode;

    /**
     * 客户端类型 0：全部  1：IOS 2：ANDROID
     */
    private Integer clientType;


    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
