package cn.com.wawa.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class RewardTaskDto implements Serializable {

    private static final long serialVersionUID = 6177033192198616317L;

    private Long id;

    /**
     * 任务名称
     */
    private String taskName;
    /**
     * 活动模板id
     */
    private Long templateId;

    /**
     * 数量
     */
    private Integer num;
    /**
     * 1:抓取； 2:抓中了  (configType=2时有效)
     */
    private Integer state;
    /**
     * 排序
     */
    private Integer rank;
    /**
     * 奖励内容(json)
     * 要加概率
     */
    private String prizeJson;
    /**
     * 类型 1:抽奖宝箱 2:每日任务 3:活跃度
     */
    private Integer taskType;
    /**
     * 上架日期
     */
    private Date startTime;
    /**
     * 下架日期
     */
    private Date endTime;

}
