package cn.com.wawa.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class TimeLimitResultRecordDto implements Serializable {

    private static final long serialVersionUID = -4071047903924635294L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 用户 id
     */
    private Long userId;

    /**
     * 娃娃机 id
     */
    private Long catcherId;

    /**
     * 花费
     */
    private Long price;

    /**
     * 得分
     */
    private Integer score;

    /**
     * 抓中数量
     */
    private Integer catchedNum;

    /**
     * 最高连抓数量
     */
    private Integer continuousCatchedNum;

    /**
     * 兑换券数量
     */
    private Integer ticketNum;

    /**
     * 抓取视频
     */
    private String videoUrl;

    /**
     * 游戏开始时间
     */
    private Date startTime;

    /**
     * 游戏结束时间
     */
    private Date endTime;

    /**
     * 是否首次玩 0.否 1.是
     */
    private Integer firstState;

    /**
     * 客户端类型:0：未知 1：IOS 2:安卓 3:h5
     */
    private Integer clientType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    private Long battleId;//对局id
    private String playType;//玩法类型
    private Long originalOrderId;//原始订单ID，机器人订单有值
    private String originalOrderType;//原始订单类型：REPO-备选库订单；MAIN-用户游戏订单
    private String userType;//用户类型：NORMAL-普通用户；ROBOT-机器人
    private Long fee;//费用，平台抽成的抓抓币数量，挑战玩法胜利或平均时有值
    private Long winCoin;//用户赢得的抓抓币
    private Integer playTime;//游戏时长
}
