package cn.com.wawa.service.api.dto;

import cn.com.wawa.service.api.enums.WawaCatcherHealthStatusEnum;
import cn.com.wawa.service.api.enums.WawaCatcherStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by gyf . 2017/10/27 .
 */
@Data
public class WawaCatcherDto implements Serializable {

    private static final long serialVersionUID = 7674424771006935130L;
    
    /** 娃娃机redis锁key值前缀 */
    public static final String CATCHER_REDIS_LOCK = "CATCHER_REDIS_LOCK_";

    /**
     * 娃娃机id
     */
    private Long id;

    /**
     * 娃娃机名称
     */
    private String catcherName;

    /**
     * 娃娃机上配置的价格/ 需要使用娃娃覆盖
     */
    private Long price;

    /**
     * 娃娃机排序值
     */
    private Long payload;

    /**
     * 娃娃id
     */
    private Long wawaId;

    /**
     * 娃娃图
     */
    private String indexImage;

    /**
     * 娃娃名称
     */
    private String wawaName;

    /**
     * 状态 0补货维护 1上架
     */
    private WawaCatcherStatusEnum catcherStatus;

    /**
     * 健康状态 0健康 1不健康
     */
    private WawaCatcherHealthStatusEnum healthStatus;

    /**
     * 最新一次上架时间
     */
    private Date lastOnshelfTime;

    /**
     * 娃娃总数
     */
    private Integer totality;

    /**
     * 娃娃剩余数量
     */
    private Integer stock;

    /**
     * 娃娃机版本号
     */
    private String catcherVersion;

    /**
     * 最后补齐娃娃数量时间
     */
    private Date lastPolishTime;

    private String remark;

    private Integer row;
    /**
     * 玩法类型 1.经典玩法 2.限时玩法
     */
    private Integer playType;

    /**
     * 房间编号
     */
    private String roomId;
}
