package cn.com.wawa.service.api.enums;

public enum BannerCardUserTypeEnum {

    ALL(0, "全部用户"),
    NEW(1, "新用户(没抓中过)"),
    OLD(2, "老用户(抓中过)");

    private int value;
    private String desc;

    BannerCardUserTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static BannerCardUserTypeEnum get(int value) {
        for (BannerCardUserTypeEnum item : BannerCardUserTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }


}
